function [B,B0,N,I,fD,fL,fL0,g,Uw] = ...
    GetDLOmatrices(NODE, BARS, BARMAT, boundBARS, suppBOUND, loadBOUND,...
                   loadBOUNDvals, weightNODE, uw, FS)
% Geometry properties
Nb = size(BARS,1);
Nn = size(NODE,1);
alpha = NODE(BARS(:, 2), 1) - NODE(BARS(:, 1), 1);
beta = NODE(BARS(:, 2), 2) - NODE(BARS(:, 1), 2);
L = sqrt(alpha.^2 + beta.^2);
alpha = alpha./L;
beta = beta./L;

% Kinematic compatibility
B = sparse(2 * Nn, 2 * Nb);
for i = 1:2
    nodes = [ 2*BARS(:,i).'-1   2*BARS(:,i).'  2*BARS(:,i).'-1 2*BARS(:,i).'];
    bars =  [ (1:2:2*Nb) (1:2:2*Nb) (2:2:2*Nb) (2:2:2*Nb)];
    Ti = [ alpha.' beta.'  -beta.' alpha.'];
    signs = (i == 1)*1 +  (i == 2)*-1;
    Bi = sparse(nodes,bars, signs * Ti, 2 * Nn, 2 * Nb);
    B = B + Bi;
end

% Plastic flow rule
barsi = [ (1:2:2*Nb) (1:2:2*Nb) (2:2:2*Nb) (2:2:2*Nb)];
barsj = [ (1:2:2*Nb) (2:2:2*Nb) (1:2:2*Nb) (2:2:2*Nb)];
bars = [ (1:2:2*Nb) (2:2:2*Nb)];
Ni = [ones(Nb,1)' -ones(Nb,1)' tan(BARMAT(:,2))'/FS  tan(BARMAT(:,2))'/FS];
N = sparse(barsi, barsj, Ni, 2 * Nb, 2 * Nb);
gi = [L.*BARMAT(:,1)/FS ;L.*BARMAT(:,1)/FS];
g = sparse(bars, ones(2*Nb, 1), gi, 2 * Nb, 1);

% Self weight
weight = sum(weightNODE(BARS),2) / 2;
bars = [ (1:2:2*Nb) (2:2:2*Nb)];
fDi = [-beta .* alpha .* L .* weight; -alpha .* alpha .* L .* weight];
fD = sparse(bars, ones(2*Nb, 1), fDi, 2 * Nb, 1);

% External force
fL = sparse(2 * Nb, 1);
if size(loadBOUNDvals,1) ~= 0
    boundIND = boundBARS(loadBOUND);
    fx = loadBOUNDvals(:,1).*L(boundIND);
    fy = loadBOUNDvals(:,2).*L(boundIND);
    fL(2*boundIND-1,:) = fx.*abs(alpha(boundIND)) + fy.*abs(beta(boundIND));
    fL(2*boundIND,:) = -fx.*abs(beta(boundIND)) + fy.*abs(alpha(boundIND));
end 

% Pore pressure
Uwi = uw(BARS(:,1));
Uwj = uw(BARS(:,2));
Uw = zeros(Nb, 1);
bars = (2:2:2*Nb);
cond1 = (Uwi >= 0) & (Uwj >= 0);
cond2 = (Uwi >= 0) & (Uwj < 0);
cond3 = (Uwi < 0) & (Uwj >= 0);
cond4 = (Uwi < 0) & (Uwj < 0);
Uw(cond1) = (Uwi(cond1) + Uwj(cond1))/2;
Uw(cond2) = Uwi(cond2) .* Uwi(cond2) ./ (2 * (Uwi(cond2) - Uwj(cond2)));
Uw(cond3) = Uwj(cond3) .* Uwj(cond3) ./ (2 * (Uwj(cond3) - Uwi(cond3)));
Uw(cond4) = 0;
Uw = sparse(bars, ones(Nb, 1), Uw.*L, 2 * Nb, 1);

% Free boundary
bars = boundBARS(~suppBOUND);
outbars = [2*bars-1 2*bars];
outbars = reshape(outbars,1,2*size(bars,1));

B0 = zeros(size(B,1), size(B,2));
fL0 = zeros(size(fL,1), size(fL,2));
I = speye(2*size(BARS,1));
g(outbars) = [];
N(outbars,:) = [];
N(:,outbars) = [];
I(outbars,:) = [];
B0(:,outbars) = [];
fL0(outbars,:) = [];

return 